# Generated by Django 3.2.16 on 2023-01-09 14:32

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Album',
            fields=[
                ('created_datetime', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_datetime', models.DateTimeField(auto_now=True, verbose_name='Last update at')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('album_name', models.CharField(max_length=512, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Artiste',
            fields=[
                ('created_datetime', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_datetime', models.DateTimeField(auto_now=True, verbose_name='Last update at')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('stage_name', models.CharField(blank=True, max_length=256)),
                ('profile_picture', models.ImageField(blank=True, upload_to='')),
                ('is_accepted_terms', models.BooleanField(default=False)),
                ('is_accepted_privacy', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VideoMedia',
            fields=[
                ('created_datetime', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_datetime', models.DateTimeField(auto_now=True, verbose_name='Last update at')),
                ('title', models.CharField(max_length=512, null=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('cover_image', models.ImageField(blank=True, upload_to='cover-images')),
                ('duration', models.CharField(blank=True, editable=False, max_length=15)),
                ('video_file', models.FileField(upload_to='')),
                (
                    'artiste',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name='video_medias', to='artiste.artiste'
                    ),
                ),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Links',
            fields=[
                ('created_datetime', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_datetime', models.DateTimeField(auto_now=True, verbose_name='Last update at')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('link_url', models.URLField(blank=True)),
                (
                    'link_type',
                    models.IntegerField(
                        choices=[
                            (0, 'Hiphop'),
                            (1, 'Apple'),
                            (2, 'Spotify'),
                            (3, 'Tiktok'),
                            (4, 'Youtube'),
                            (5, 'Instagram'),
                            (6, 'Twitter'),
                            (7, 'Genius'),
                        ],
                        default=0,
                    ),
                ),
                (
                    'artiste',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name='links', to='artiste.artiste'
                    ),
                ),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AudioMedia',
            fields=[
                ('created_datetime', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_datetime', models.DateTimeField(auto_now=True, verbose_name='Last update at')),
                ('title', models.CharField(max_length=512, null=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('cover_image', models.ImageField(blank=True, upload_to='cover-images')),
                ('duration', models.CharField(blank=True, editable=False, max_length=15)),
                ('audio_file', models.FileField(upload_to='')),
                (
                    'album',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='albums',
                        to='artiste.album',
                    ),
                ),
                (
                    'artiste',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name='audio_medias', to='artiste.artiste'
                    ),
                ),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='artiste',
            name='profile_song',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='artiste_profile_song',
                to='artiste.audiomedia',
            ),
        ),
        migrations.AddField(
            model_name='artiste',
            name='user',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, related_name='artiste', to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.AddField(
            model_name='album',
            name='artiste',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name='albums',
                to='artiste.artiste',
            ),
        ),
    ]
