from typing import Any

from rest_framework import serializers

from apps.comments.models import ArtisteComments, MediaComments


class MediaCommentsSerializer(serializers.ModelSerializer):
    fan_name = serializers.CharField(source='fan.user.first_name')
    fan_id = serializers.CharField(source='fan.id')

    def get_name(self, obj: MediaComments):
        return obj.fan.user.username

    class Meta:
        model = MediaComments
        fields = ['id', 'comment', 'fan_name', 'fan_id', 'created_datetime']

    def create(self, validated_data: Any):
        return MediaComments.objects.create(
            media=self.context['media'], fan=self.context['fan'], comment=validated_data['comment']
        )


class DeleteMediaCommentsSerializer(serializers.ModelSerializer):
    class Meta:
        model = MediaComments
        fields = '__all__'
        read_only_fields = ['fan', 'media', 'comment']

    def update(self, instance: MediaComments, validated_data: Any):
        instance.delete()
        return instance


class ArtisteCommentsSerializer(serializers.ModelSerializer):
    fan_name = serializers.CharField(source='fan.user.first_name')
    fan_id = serializers.CharField(source='fan.id')
    fan_profile_picture = serializers.CharField(source='fan.profile_picture')


    def get_name(self, obj: ArtisteComments):
        return obj.fan.user.username

    class Meta:
        model = ArtisteComments
        fields = ['id', 'comment', 'fan_name', 'fan_id', 'created_datetime','fan_profile_picture']

    def create(self, validated_data: Any):
        return ArtisteComments.objects.create(
            artiste=self.context['artiste'], fan=self.context['fan'], comment=validated_data['comment']
        )


class DeleteArtisteCommentsSerializer(serializers.ModelSerializer):
    class Meta:
        model = ArtisteComments
        fields = '__all__'
        read_only_fields = ['fan', 'artiste', 'comment']

    def update(self, instance: ArtisteComments, validated_data: Any):
        instance.delete()
        return instance
