from django.urls import path

from apps.comments.api.v1.views import (
    ArtisteCommentsAPIView,
    CreateArtisteCommentAPIView,
    CreateMediaCommentAPIView,
    DeleteArtisteCommentAPIView,
    DeleteMediaCommentAPIView,
    MediaCommentsAPIView,
)

app_name = "comments_api"

urlpatterns = [
    path('create-media-comment/<str:media_uuid>/', CreateMediaCommentAPIView.as_view(), name='create_media_comment'),
    path('delete-media-comment/<str:comment_uuid>/', DeleteMediaCommentAPIView.as_view(), name='delete_media_comment'),
    path('media-comments/<str:media_uuid>/', MediaCommentsAPIView.as_view(), name='media_comments'),
    path(
        'create-artiste-comment/<str:artiste_uuid>/',
        CreateArtisteCommentAPIView.as_view(),
        name='create_artiste_comment',
    ),
    path(
        'delete-artiste-comment/<str:comment_uuid>/',
        DeleteArtisteCommentAPIView.as_view(),
        name='delete_artiste_comment',
    ),
    path('artiste-comments/<str:artiste_uuid>/', ArtisteCommentsAPIView.as_view(), name='artiste_comments'),
]
