import uuid

from django.db import models

from apps.lib.base_model import BaseAbstractModel


# Create your models here.
class MediaComments(BaseAbstractModel):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    media = models.ForeignKey('artiste.AudioMedia', on_delete=models.CASCADE, related_name='comments')
    fan = models.ForeignKey('users.Fan', on_delete=models.CASCADE, related_name='media_comments')
    comment = models.TextField()

    class Meta:
        ordering = ['-created_datetime']

    def __str__(self):
        return f'{self.fan.user.email}'


class ArtisteComments(BaseAbstractModel):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    artiste = models.ForeignKey('artiste.Artiste', on_delete=models.CASCADE, related_name='comments')
    fan = models.ForeignKey('users.Fan', on_delete=models.CASCADE, related_name='artiste_comments')
    comment = models.TextField()

    class Meta:
        ordering = ['-created_datetime']

    def __str__(self):
        return f'ArtisteComment: {self.artiste.user.email} - {self.fan.user.email}'
