import uuid

from django.db import models

from apps.lib.base_model import BaseAbstractModel
from apps.lib.constants import USER_TYPES


# Create your models here.
class TermsAndConditions(BaseAbstractModel):

    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    body = models.TextField()
    user = models.ForeignKey(
        'users.User',
        on_delete=models.CASCADE,
    )
    is_active = models.BooleanField(default=True)
    user_type = models.IntegerField(choices=USER_TYPES, null=True)

    class Meta:
        verbose_name = 'TermsAndConditions'
        verbose_name_plural = 'TermsAndConditions'
