from django.urls import include, path

from profiles import views

urlpatterns = [
    path("profile/", views.UserProfileView.as_view()),
    path("profile/upload-image/", views.UserProfilePictureUpdate.as_view()),
    path('api-auth/', include('rest_framework.urls', namespace='rest_framework')),
    path("profile/liked-songs/", views.LikedSongsListView.as_view()),
    path("profile/artists-followed/", views.FollowedArtistsView.as_view()),
    path("trending-songs", views.TrendingSongView.as_view()),
    path("get-trivia", views.GetTrivia.as_view(), name="get-trivia"),
    path('start-game', views.StartGame.as_view(), name='start_game'),
    path('submit-answer', views.SubmitAnswer.as_view(), name='submit_answer'),
    path('finish-game', views.FinishGame.as_view(), name='finish_game'),
    path('leaderboard', views.Leaderboard.as_view(), name='leaderboard'),
    path('get-artist-pack',views.GetArtistPack.as_view(),name='get-artist-pack'),
    path('purchase-artist-pack',views.PurchaseArtistPack.as_view(),name='purchase-artist-pack'),
    path('create-stripe-payment-intent',views.CreateStripePaymentIntent.as_view(),name='create-stripe-payment-intent'),
    path('my-payment-history',views.myPaymentHistory.as_view(),name='my-payment-history'),

    path('purchase-artist-pack-gpay',views.PurchaseArtistPackGpay.as_view(),name='purchase-artist-pack-gpay'),
    

    # api changes
    path("search/", views.SearchAPIView.as_view()),
    path('suggestions/', views.SuggestionView.as_view(), name='suggestions'),
    path("terms-and-conditions/", views.TermsAndConditionsAPIView.as_view(), name="terms_and_conditions"),
    path("create-app/", views.CreateAppAPIView.as_view(), name="create_app"),
    
    
    
]
