"""
Django settings for soft_sun_26825 project.

Generated by 'django-admin startproject' using Django 2.2.2.

For more information on this file, see
https://docs.djangoproject.com/en/2.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.2/ref/settings/
"""

import logging
import os

import environ

from azure.identity import DefaultAzureCredential
from azure.keyvault.secrets import SecretClient
import io

# SECURITY WARNING: don't run with debug turned on in production!

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
from pathlib import Path

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent

# env_file = os.path.join(BASE_DIR, ".env")
env = environ.Env()
# env.read_env(env_file)

DEBUG = env.bool("DEBUG", default=False)


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = env.str("SECRET_KEY")

ALLOWED_HOSTS = ["*"]
SITE_ID = 1

SECURE_PROXY_SSL_HEADER = ("HTTP_X_FORWARDED_PROTO", "https")
SECURE_SSL_REDIRECT = env.bool("SECURE_REDIRECT", default=False)

try:
    # Retrieve secrets from Azure Key Vault
    azure_credentials = DefaultAzureCredential()
    vault_url = env.str("AZURE_KEYVAULT_RESOURCEENDPOINT", "")
    vault_secret_name = env.str("AZURE_KEY_VAULT_SECRET_NAME", "secrets")
    client = SecretClient(vault_url=vault_url, credential=azure_credentials)
    secret = client.get_secret(vault_secret_name)
    env.read_env(io.StringIO(secret.value))
except Exception as e:
    pass

# Configuration for Azure Storage
# AS_BUCKET_NAME = env.str("AS_BUCKET_NAME", "")
# if AS_BUCKET_NAME:
#     AZURE_ACCOUNT_NAME = AS_BUCKET_NAME
#     AZURE_TOKEN_CREDENTIAL = DefaultAzureCredential()
#     AS_STATIC_CONTAINER = env.str("AS_STATIC_CONTAINER", "static")
#     AS_MEDIA_CONTAINER = env.str("AS_MEDIA_CONTAINER", "media")
#     AZURE_URL_EXPIRATION_SECS = env.int("AZURE_URL_EXPIRATION_SECS", 3600)
#     DEFAULT_FILE_STORAGE = "soft_sun_26825.storage_backends.AzureMediaStorage"
#     STATICFILES_STORAGE = "soft_sun_26825.storage_backends.AzureStaticStorage"

# Application definition

INSTALLED_APPS = [
    'jazzmin',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',
]
THIRD_PARTY_APPS = [
    'rest_framework',
    ######OAUTH2#######
    'oauth2_provider',
    'social_django',
    'drf_social_oauth2',
    ####################
    'drf_yasg',
    'storages',
    'drf_api_logger',
    'django_filters',
    # end fcm_django push notifications
    'django_db_logger',
]

LOCAL_APPS = [
    'modules',
    'users.apps.UsersConfig',
    'profiles',
    'apps.lib',
    'apps.actions',
    'apps.artiste',
    'apps.comments',
    'admin_panel',
]
INSTALLED_APPS += LOCAL_APPS + THIRD_PARTY_APPS

MIDDLEWARE = [
    'corsheaders.middleware.CorsMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'drf_api_logger.middleware.api_logger_middleware.APILoggerMiddleware',
    'soft_sun_26825.exception_logger.LogExceptionMiddleware',
]

ROOT_URLCONF = 'soft_sun_26825.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR, 'templates')],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'soft_sun_26825.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.2/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}

if env.str("DATABASE_URL", default=None):
    DATABASES = {'default': env.db()}


# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'UTC'
USE_I18N = True
USE_L10N = True
USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.2/howto/static-files/

STATIC_URL = '/static/'

MIDDLEWARE += ['whitenoise.middleware.WhiteNoiseMiddleware']

AUTHENTICATION_BACKENDS = (
    'django.contrib.auth.backends.ModelBackend',
    'drf_social_oauth2.backends.DjangoOAuth2',
    'social_core.backends.google.GoogleOAuth2',
    'social_core.backends.apple.AppleIdAuth',
    # Facebook OAuth2
    'social_core.backends.facebook.FacebookAppOAuth2',
    'social_core.backends.facebook.FacebookOAuth2',
)

STATIC_ROOT = os.path.join(BASE_DIR, "static")
STATICFILES_STORAGE = 'whitenoise.storage.CompressedManifestStaticFilesStorage'


# Custom user model
AUTH_USER_MODEL = "users.User"

EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
# EMAIL_HOST = env.str("EMAIL_HOST", "smtp.sendgrid.net")
# EMAIL_HOST_USER = env.str("EMAIL_HOST_USER", "")
# EMAIL_HOST_PASSWORD = env.str("EMAIL_HOST_PASSWORD", "")
# EMAIL_PORT = 587
# EMAIL_USE_TLS = True


EMAIL_HOST = 'smtp.gmail.com'
EMAIL_USE_TLS = False
EMAIL_USE_SSL = True
EMAIL_PORT = 465
EMAIL_HOST_USER = 'testeresfera@gmail.com'
EMAIL_HOST_PASSWORD = 'muwibyilubnetaqi'



# AWS S3 config
AWS_ACCESS_KEY_ID = env.str("AWS_ACCESS_KEY_ID", "")
AWS_SECRET_ACCESS_KEY = env.str("AWS_SECRET_ACCESS_KEY", "")
AWS_STORAGE_BUCKET_NAME = env.str("AWS_STORAGE_BUCKET_NAME", "")
AWS_STORAGE_REGION = env.str("AWS_STORAGE_REGION", "")

USE_S3 = AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY and AWS_STORAGE_BUCKET_NAME and AWS_STORAGE_REGION

if USE_S3:
    AWS_S3_CUSTOM_DOMAIN = env.str("AWS_S3_CUSTOM_DOMAIN", "")
    AWS_S3_OBJECT_PARAMETERS = {"CacheControl": "max-age=86400"}
    AWS_DEFAULT_ACL = env.str("AWS_DEFAULT_ACL", "public-read")
    AWS_MEDIA_LOCATION = env.str("AWS_MEDIA_LOCATION", "media")
    AWS_AUTO_CREATE_BUCKET = env.bool("AWS_AUTO_CREATE_BUCKET", True)
    DEFAULT_FILE_STORAGE = env.str("DEFAULT_FILE_STORAGE", "users.storage_backends.MediaStorage")
    AWS_QUERYSTRING_AUTH = False
MEDIA_URL = '/mediafiles/'
MEDIA_ROOT = os.path.join(BASE_DIR, 'mediafiles')

REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'oauth2_provider.contrib.rest_framework.OAuth2Authentication',
        'drf_social_oauth2.authentication.SocialAuthentication',
        'rest_framework.authentication.BasicAuthentication',
        'rest_framework.authentication.SessionAuthentication',
    ),
    # Use Django's standard `django.contrib.auth` permissions,
    # or allow read-only access for unauthenticated users.
    # 'DEFAULT_PERMISSION_CLASSES': ['rest_framework.permissions.DjangoModelPermissionsOrAnonReadOnly'],
    'DEFAULT_PERMISSION_CLASSES': ['rest_framework.permissions.IsAuthenticated'],
    "DEFAULT_PAGINATION_CLASS": "rest_framework.pagination.LimitOffsetPagination",
    "PAGE_SIZE": 25,
}

# Temporary
CORS_ALLOW_ALL_ORIGINS = True

# Swagger settings for api docs
SWAGGER_SETTINGS = {
    "DEFAULT_INFO": f"{ROOT_URLCONF}.api_info",
}

if DEBUG or not (EMAIL_HOST_USER and EMAIL_HOST_PASSWORD):
    # output email to console instead of sending
    if not DEBUG:
        logging.warning("You should setup `SENDGRID_USERNAME` and `SENDGRID_PASSWORD` env vars to send emails.")
    EMAIL_BACKEND = "django.core.mail.backends.console.EmailBackend"


STRIPE_PUBLISHABLE = env.str("STRIPE_PUBLISHABLE", "")
STRIPE_SECRET = env.str("STRIPE_SECRET", "")
STRIPE_WEBHOOK_SECRET = env.str("STRIPE_WEBHOOK_SECRET", "")

# Google configuration
SOCIAL_AUTH_GOOGLE_OAUTH2_KEY = env.str("SOCIAL_AUTH_GOOGLE_OAUTH2_KEY", "")
SOCIAL_AUTH_GOOGLE_OAUTH2_SECRET = env.str("SOCIAL_AUTH_GOOGLE_OAUTH2_SECRET", "")


# AppleID
SOCIAL_AUTH_APPLE_ID_CLIENT = env.str("SOCIAL_AUTH_APPLE_ID_CLIENT", "")  # app bundle identifier
SOCIAL_AUTH_APPLE_ID_TEAM = env.str("SOCIAL_AUTH_APPLE_ID_TEAM", "")  # apple team ID
SOCIAL_AUTH_APPLE_ID_KEY = env.str("SOCIAL_AUTH_APPLE_ID_KEY", "")  # apple KEY ID
SOCIAL_AUTH_APPLE_ID_SECRET = env.str("SOCIAL_AUTH_APPLE_ID_SECRET", "", multiline=True)  # APPLE Secret key
SOCIAL_AUTH_APPLE_ID_SCOPE = ['email', 'name']
SOCIAL_AUTH_APPLE_ID_EMAIL_AS_USERNAME = True

# Define SOCIAL_AUTH_GOOGLE_OAUTH2_SCOPE to get extra permissions from Google.
SOCIAL_AUTH_GOOGLE_OAUTH2_SCOPE = [
    'https://www.googleapis.com/auth/userinfo.email',
    'https://www.googleapis.com/auth/userinfo.profile',
]

SOCIAL_AUTH_FACEBOOK_KEY = env.str("SOCIAL_AUTH_FACEBOOK_KEY", "")
SOCIAL_AUTH_FACEBOOK_SECRET = env.str("SOCIAL_AUTH_FACEBOOK_SECRET", "")
SOCIAL_AUTH_FACEBOOK_SCOPE = ['email']
SOCIAL_AUTH_FACEBOOK_PROFILE_EXTRA_PARAMS = {'fields': 'id, first_name, last_name, email'}


LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {'format': '%(levelname)s %(asctime)s %(module)s %(process)d %(thread)d %(message)s'},
        'simple': {'format': '%(levelname)s %(asctime)s %(message)s'},
    },
    'handlers': {
        'db_log': {'level': 'DEBUG', 'class': 'django_db_logger.db_log_handler.DatabaseLogHandler'},
    },
    'loggers': {'db': {'handlers': ['db_log'], 'level': 'DEBUG'}},
}

# JAZZMIN_SETTINGS = {
#     "hide_apps": [
#         'oauth2_provider',
#         'social_django',
#         'drf_social_oauth2',
#     ],
#     "hide_models": ["auth.group"],
# }

ACCESS_TOKEN_EXPIRE_SECONDS = 172800
DOMAIN_URL=env.str("DOMAIN_URL", "")


OPEN_AI_KEY = "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"
STRIPE_SECRET_KEY = "sk_test_51K54oQGZOiEmnLbL5qeXEZ4OUP48eE0Id6o6OMdzyR8CPBS5gBXsxDcUSjVGzPe0yqVCABwK9M8dW79QKRqO6AKs00U60su3Pm"
