"""soft_sun_26825 URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/2.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""

from django.conf.urls.static import static
from django.contrib import admin
from django.conf import settings
from django.urls import include, path
from drf_yasg import openapi
from drf_yasg.views import get_schema_view
from rest_framework import permissions

urlpatterns = [
    path("", include("profiles.urls")),
    path("accounts/", include("users.urls")),
    path("modules/", include("modules.urls")),
    
    path("admin/", admin.site.urls),
    # ReWrite URL
    path('artiste/', include(('apps.artiste.api.v1.urls', 'artiste_api'), namespace='artiste_api')),
    path('comments/', include(('apps.comments.api.v1.urls', 'comments_api'), namespace='comments_api')),
    path('actions/', include(('apps.actions.api.v1.urls', 'actions_api'), namespace='actions_api')),
    path('',include("admin_panel.urls"))
]

if hasattr(settings, 'MEDIA_ROOT') and hasattr(settings, 'MEDIA_URL'):
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)

admin.site.site_header = "Saigon Music"
admin.site.site_title = "Saigon Music Admin Portal"
admin.site.index_title = "Saigon Music Admin"

# swagger
api_info = openapi.Info(
    title="Soft Sun API",
    default_version="v1",
    description="API documentation for Soft Sun App",
)

schema_view = get_schema_view(
    api_info,
    public=True,
    permission_classes=(permissions.AllowAny,),
)

urlpatterns += [path("api-docs/", schema_view.with_ui("swagger", cache_timeout=0), name="api_docs")]
