$.validator.addMethod("email", function(value, element) {
    return this.optional(element) || /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(value);
  }, "Please enter a valid Email address.");

$.validator.addMethod("username", function(value, element) {
    return this.optional(element) ||/^[^-\s][a-zA-Z0-9_\s-]+$/.test(value);

  }, "Please enter a valid username.");

  
$.validator.addMethod("digits", function(value, element) {
    return this.optional(element) ||/^[0-9+\s]+$/.test(value);
  }, "Please enter a valid phone number.");


    
$.validator.addMethod("priceProduct", function(value, element) {
  return this.optional(element) ||/^[1-9+\s]+$/.test(value);
}, "Please enter a price.");

jQuery.extend(jQuery.validator.messages, {
    equalTo: "Password and confirm password are not same",
});
$.validator.addMethod("password_val", function(value,element){
  return this.optional(element) ||/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{8,})/.test(value);
},"Use 8 or more characters with a mix of letters, numbers & symbols.");


$.validator.addMethod("alphabets", function(value, element) {
  return this.optional(element) ||/^[^-\s][a-zA-Z_\s-]+$/.test(value);

}, "Please enter a valid name.");

$.validator.addMethod("noSpace", function(value, element) {
  return value.trim().length !== 0; // ensures that no blank spaces are allowed
}, "Please enter a valid name without spaces.");





$("#send-support").validate({
  rules:{
    reply: {
         required:true,
      },
  },
});


$("#add-question").validate({
  rules:{
    question: {
         required:true,
      },
      options:{
        required:true,
      },

  },
});


$("#add-health-catgory").validate({
  rules:{
    name: {
         required:true,
      },
  },
});


$("#add-iv-product").validate({
  rules:{
    product_name: {
         required:true,
      },
    description: {
      required:true,
    },
    product_features: {
    required:true,
    },
    price: {
    required:true,
    priceProduct:true,
    },

  },
});

$("#admin-login").validate({
    rules:{
        password:{
            required:true,
          //   remote:{
          //    url:window.location.origin+"/check-login-password",
          //    type:"get",
          //    data: {
          //        'email': function(){ 
          //           return $('#email').val(); 
          //         }
          //      }
 
          //  }
         },
        email: {
           required:true,
            email : true,
            maxlength: 35,
            // remote:{
            //     url:window.location.origin+"/check-email",
            //     type:"get",
            //     data:{
                 
            //     },
            //   }
        },
    },
});


$("#admin-forget-password").validate({
  rules:{
      email: {
         required:true,
          email : true,
          maxlength: 35,
          remote:{
              url:window.location.origin+"/check-email",
              type:"get",
              data:{
              
              }
              
            }
      },
  },
});


$("#verify-forgot").validate({
  rules:{
      new_password: {
         required:true,
         password_val:true,
      },
      confirm_new_password: {
          required:true,
          equalTo : '[name="new_password"]',
          password_val:true,
      },
  },
});


$("#admin-profile").validate({
  rules:{
    first_name: {
         required:true,
         username:true,
         maxlength:100,

      },
      last_name: {
        required:true,
        username:true,
        maxlength:100,
     },
     email: {
      required:true,
      email:true,
      maxlength:100,

      },
      gender: {
        required:true,
    },
    phone_number:{
      required:true,
      maxlength:20,
    },
    address:{
      required:true,
      maxlength:200,
    },

  },
});



$("#admin-reset-password").validate({
  rules:{
      old_password:{
        required:true,
      },
      password: {
         required:true,
      },
      confirmPassword: {
          required:true,
          equalTo : '[name="password"]'
      },
  },
});


$("#add-patient").validate({
  rules:{
    name: {
         required:true,
         alphabets:true,
         maxlength:100,
      },   
     intel_phone_number: {
        digits:true,
    },
    email :{
      required:true,
      email:true,
      maxlength:100,

    },
    gender :{
      required:true,
    },
    blood_group :{
      required:true,
      noSpace:true,
    },
    status:{
      required:true,
    }
  },
});




$("#change-password-user").validate({
  rules:{
     password: {
         required:true,
         password_val:true,
      },
      confirmPassword: {
          required:true,
          equalTo : '[name="password"]',
          password_val:true,
      },
  },
});

$("#disapprove-doctor").validate({
  rules:{
    reason: {
         required:true,
      },
  },
});



$("#add-nurse").validate({
  rules:{
    name: {
         required:true,
         alphabets:true,
         maxlength:100,
      },   
     intel_phone_number: {
        digits:true,
    },
    email :{
      required:true,
      email:true,
      maxlength:100,

    },
    gender :{
      required:true,
    },
    dob :{
      required:true,
      maxlength:100,
    },
    experince_year:{
      required:true,
      maxlength:10,
    },
    status:{
      required:true,
    },
    higest_education:{
      required:true,
      maxlength:1000,
      noSpace:true,

    },
    overall_experince:{
      required:true,
      maxlength:1000,

    },
    other_education:{
      required:true,
      maxlength:1000,
    },
    address:{
      required:true,
      maxlength:1000,
      noSpace:true,
    }

  },
});


$("#edit-doctor-profile").validate({
  rules:{
    name: {
         required:true,
         alphabets:true,
         maxlength:100,
      },   
     intel_phone_number: {
        required:true,
        digits:true,
        maxlength:15,
    },
    email :{
      required:true,
      email:true,
      maxlength:100,

    },
    gender :{
      required:true,
    },
    dob :{
      required:true,
      maxlength:100,
    },
    experince:{
      required:true,
      maxlength:10,
    },
    status:{
      required:true,
    },
    other_educations:{
      required:true,
      maxlength:1000,
    },
    services:{
      required:true,
      maxlength:1000,
    },
    about:{
      required:true,
      maxlength:1000,
    }

  },
});


// $("#add-patient").validate({
//   rules:{
//     title: {
//         required:true,
//       },
//       content: {
//         required:true,
//      },
//   },
// });


$("#add-discover-exerices").validate({
  rules:{
    name: {
        required:true,
      },
  },
});



$("#admin-set-delivery-charges").validate({
  rules:{
    delivery_charges: {
        required:true,
      },
  },
});


