from django.db import models


class DevelopmentApplication(models.Model):
	application_id = models.CharField(max_length=100, unique=True,null=True)
	application_url = models.URLField(null=True,  blank=True)
	decision = models.CharField(max_length=100, null=True, blank=True)
	lodgement_date = models.DateField(null=True, blank=True)
	determined_date = models.DateField(null=True, blank=True)
	cost = models.FloatField(null=True, blank=True)
	council_name = models.CharField(max_length=100, null=True, blank=True)

	# Extracted Fields
	development_type = models.CharField(max_length=100, null=True, blank=True)
	number_of_dwellings = models.IntegerField(null=True, blank=True)
	number_of_storeys = models.IntegerField(null=True, blank=True)
	number_of_places = models.IntegerField(null=True, blank=True)  
	number_of_apartments = models.IntegerField(null=True, blank=True)   
	number_of_subdivisions = models.IntegerField(null=True, blank=True)    

	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now_add=True)


	class Meta:
		db_table = 'development_application'


class PDFDocument(models.Model):
	"""Model to store PDF document information"""
	application = models.ForeignKey(DevelopmentApplication, on_delete=models.CASCADE, related_name='pdf_documents')
	file_path = models.CharField(max_length=500, null=True, blank=True)
	file_name = models.CharField(max_length=255, null=True, blank=True)
	document_type = models.CharField(max_length=100, null=True, blank=True)  # Title Search, Application Form, etc.
	pdf_type = models.CharField(max_length=50, null=True, blank=True)  # digital, scanned, mixed
	confidence = models.CharField(max_length=20, null=True, blank=True)  # high, medium, low
	text_length = models.IntegerField(null=True, blank=True)
	pages_processed = models.IntegerField(null=True, blank=True)
	extraction_status = models.CharField(max_length=50, default='pending')  # pending, success, failed
	error_message = models.TextField(null=True, blank=True)
	
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)

	class Meta:
		db_table = 'pdf_document'


class ExtractedPDFData(models.Model):
	"""Model to store structured data extracted from PDFs"""
	pdf_document = models.OneToOneField(PDFDocument, on_delete=models.CASCADE, related_name='extracted_data')
	
	# Basic document information
	land_description = models.TextField(null=True, blank=True)
	registered_proprietor = models.TextField(null=True, blank=True)
	encumbrances = models.TextField(null=True, blank=True)
	activity_last_125_days = models.TextField(null=True, blank=True)
	administrative_notices = models.TextField(null=True, blank=True)
	
	# Application-specific fields
	proposed_use = models.CharField(max_length=200, null=True, blank=True)
	description = models.TextField(null=True, blank=True)
	
	# Contact information
	applicant_name = models.CharField(max_length=200, null=True, blank=True)
	contact_name = models.CharField(max_length=200, null=True, blank=True)
	contact_address = models.TextField(null=True, blank=True)
	contact_email = models.EmailField(null=True, blank=True)
	contact_phone = models.CharField(max_length=50, null=True, blank=True)
	applicant_address = models.TextField(null=True, blank=True)
	applicant_email = models.EmailField(null=True, blank=True)
	applicant_phone = models.CharField(max_length=50, null=True, blank=True)
	
	# Development summary fields
	lot_size = models.CharField(max_length=100, null=True, blank=True)
	site_coverage = models.CharField(max_length=100, null=True, blank=True)
	total_area = models.CharField(max_length=100, null=True, blank=True)
	ground_floor_area = models.CharField(max_length=100, null=True, blank=True)
	first_floor_area = models.CharField(max_length=100, null=True, blank=True)
	pos = models.CharField(max_length=100, null=True, blank=True)  # Private Open Space
	spos = models.CharField(max_length=100, null=True, blank=True)  # Secluded Private Open Space
	
	# Raw extracted data as JSON (for backup/debugging)
	raw_extracted_data = models.JSONField(null=True, blank=True)
	
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)

	class Meta:
		db_table = 'extracted_pdf_data'