EXTRACT_STRUCTURED_DATA_PROMPT = """
You are a helpful assistant extracting structured data from urban planning descriptions.

Your task is to extract the following fields from the description below. If a field is not mentioned or unclear, return null or 0 appropriately.

Return your response in **valid JSON**, no comments, no additional text.

**Fields to extract**:
- development_type: A short label for the overall development (e.g., Residential, Industrial, Subdivision, Vegetation Removal, Mixed Use, Community Facility, etc.)
- number_of_dwellings: Number of houses/dwellings (e.g., 3 if "construct three dwellings")
- number_of_storeys: Maximum storey count across buildings, if available (e.g., 2 for double storey)
- number_of_places: Number of places if it's Childcare / Medical / Aged Care (e.g., 60 childcare places)
- number_of_units: Number of units for apartments or townhouses
- number_of_lots: Number of lots if subdivision is mentioned

**Description**:
\"\"\"
{description}
\"\"\"

Respond in this JSON format:

{{
  "development_type": "...",
  "number_of_dwellings": ...,
  "number_of_storeys": ...,
  "number_of_places": ...,
  "number_of_units": ...,
  "number_of_lots": ...
}}
"""

TITLE_SEARCH_EXTRACTION_PROMPT = """
You are extracting information from a Title Search document. Extract the following fields in JSON format. If a field is not found, use empty string or null as appropriate.

{{
  "document_type": "Title Search",
  "land_description": "",
  "registered_proprietor": "",
  "encumbrances": "",
  "activity_last_125_days": "",
  "administrative_notices": "",
  "development_summary": {{
    "lot_size": "",
    "site_coverage": "",
    "total_area": "",
    "ground_floor_area": "",
    "first_floor_area": "",
    "pos": "",
    "spos": ""
  }}
}}

NOTE: 
- "Land Description" should include the full property address (e.g., "3 Hopetoun Street NORTHCOTE VIC 3070")
- "Registered Proprietor" is the legal owner of the land (person or entity name)
- "Encumbrances" are any restrictions, easements, or charges on the title (if none, use "None" or "No encumbrances")
- "Activity in the last 125 days" refers to recent dealings or changes to the title (if none, use "No recent activity")
- "Administrative Notices" are any official notices affecting the title (if none, use "None" or "No notices")
- "lot_size" should be in square meters (m2)
- "site_coverage" should be a percentage (%)
- "total_area" should be in square meters (m2)
- "ground_floor_area" should be in square meters (m2)
- "first_floor_area" should be in square meters (m2)
- "pos" means Private Open Space (grass area) in square meters (m2)
- "spos" means Secluded Private Open Space (private garden area) in square meters (m2)

Look for these specific sections in the document and extract the exact text found.
Text to extract from:
'''{text}'''
"""

APPLICATION_FORM_EXTRACTION_PROMPT = """
You are extracting information from an Application Form document. Extract the following fields in JSON format. If a field is not found, use empty string or null as appropriate.

{{
  "document_type": "Application Form",
  "land_description": "",
  "registered_proprietor": "",
  "encumbrances": "",
  "activity_last_125_days": "",
  "administrative_notices": "",
  "proposed_use": "",
  "description": "",
  "applicant_name": "",
  "contact_name": "",
  "contact_address": "",
  "contact_email": "",
  "contact_phone": "",
  "applicant_address": "",
  "applicant_email": "",
  "applicant_phone": "",
  "development_summary": {{
    "lot_size": "",
    "site_coverage": "",
    "total_area": "",
    "ground_floor_area": "",
    "first_floor_area": "",
    "pos": "",
    "spos": ""
  }}
}}

NOTE: 
- "Land Description" should include the full property address (e.g., "3 Hopetoun Street NORTHCOTE VIC 3070")
- "Registered Proprietor" is the legal owner of the land (person or entity name)
- "Encumbrances" are any restrictions, easements, or charges on the title (if none, use "None" or "No encumbrances")
- "Activity in the last 125 days" refers to recent dealings or changes to the title (if none, use "No recent activity")
- "Administrative Notices" are any official notices affecting the title (if none, use "None" or "No notices")
- "Proposed Use" is the intended use of the land/development (e.g., "Residential/Accommodation", "Commercial", "Industrial")
- "Description" provides details about what the permit is for (e.g., "Two (2) Dwellings on Two (2) Lots as shown on the plans accompanying the application")
- "lot_size" should be in square meters (m2)
- "site_coverage" should be a percentage (%)
- "total_area" should be in square meters (m2)
- "ground_floor_area" should be in square meters (m2)
- "first_floor_area" should be in square meters (m2)
- "pos" means Private Open Space (grass area) in square meters (m2)
- "spos" means Secluded Private Open Space (private garden area) in square meters (m2)
- "Applicant Name" is the name of the person or entity applying for the permit
- "Contact Name" is the name of the primary contact person (may be same as applicant or different)
- "Contact Address" is the full address of the contact person
- "Contact Email" is the email address of the contact person
- "Contact Phone" is the phone number of the contact person
- "Applicant Address" is the full address of the applicant (may be same as contact address)
- "Applicant Email" is the email address of the applicant
- "Applicant Phone" is the phone number of the applicant

Look for these specific fields in the application form and extract the exact text found. Pay special attention to sections labeled "Applicant Details", "Contact Information", "Owner Details", or similar headings.

Text to extract from:
'''{text}'''
"""

APPLICATION_FORM_FALLBACK_PROMPT = """
You are extracting information from an Application Form document that couldn't be classified as a standard application form. Extract the following fields in JSON format. If a field is not found, use empty string or null as appropriate.

{{
  "document_type": "Application Form",
  "land_description": "",
  "registered_proprietor": "",
  "encumbrances": "",
  "activity_last_125_days": "",
  "administrative_notices": "",
  "proposed_use": "",
  "description": "",
  "applicant_name": "",
  "contact_name": "",
  "contact_address": "",
  "contact_email": "",
  "contact_phone": "",
  "applicant_address": "",
  "applicant_email": "",
  "applicant_phone": "",
  "development_summary": {{
    "lot_size": "",
    "site_coverage": "",
    "total_area": "",
    "ground_floor_area": "",
    "first_floor_area": "",
    "pos": "",
    "spos": ""
  }}
}}

NOTE: 
- "Land Description" should include the full property address (e.g., "3 Hopetoun Street NORTHCOTE VIC 3070")
- "Registered Proprietor" is the legal owner of the land (person or entity name)
- "Encumbrances" are any restrictions, easements, or charges on the title (if none, use "None" or "No encumbrances")
- "Activity in the last 125 days" refers to recent dealings or changes to the title (if none, use "No recent activity")
- "Administrative Notices" are any official notices affecting the title (if none, use "None" or "No notices")
- "Proposed Use" is the intended use of the land/development (e.g., "Residential/Accommodation", "Commercial", "Industrial")
- "Description" provides details about what the permit is for (e.g., "Two (2) Dwellings on Two (2) Lots as shown on the plans accompanying the application")
- "lot_size" should be in square meters (m2)
- "site_coverage" should be a percentage (%)
- "total_area" should be in square meters (m2)
- "ground_floor_area" should be in square meters (m2)
- "first_floor_area" should be in square meters (m2)
- "pos" means Private Open Space (grass area) in square meters (m2)
- "spos" means Secluded Private Open Space (private garden area) in square meters (m2)
- "Applicant Name" is the name of the person or entity applying for the permit
- "Contact Name" is the name of the primary contact person (may be same as applicant or different)
- "Contact Address" is the full address of the contact person
- "Contact Email" is the email address of the contact person
- "Contact Phone" is the phone number of the contact person
- "Applicant Address" is the full address of the applicant (may be same as contact address)
- "Applicant Email" is the email address of the applicant
- "Applicant Phone" is the phone number of the applicant

Look for these specific fields in the application form and extract the exact text found. Pay special attention to sections labeled "Applicant Details", "Contact Information", "Owner Details", "Development Summary", "Site Details", or similar headings.

Text to extract from:
'''{text}'''
"""