from django.urls import path
from . import views
from shaoApp.views import *


urlpatterns = [
    
    path('files/merge/', mergeCsvFilesView, name='merge_csv_files'),
    path('files/enrich/', enrichMergedFileView, name='enrich_csv_file'),
    path('database/import/', importEnrichedDataView, name='import_data_to_db'),
    path('files/enrich-pdf/', mergeWithNameFromScraperView, name='enrich_pdf'),
    path('files/check-pdf-exist/',checkExistingPdfFilesView, name='check_pdf_exist'),
    path('files/extract-pdf-data/',extractPdfData, name='extract_pdf_data'),
    path('database/pdf-data/', getPdfDataFromDatabase, name='get_pdf_data_from_db'),
    # Chatbot API endpoints
    path('api/chat/', views.chat_endpoint, name='chat_endpoint'),
    path('api/chatbot/stats/', views.chatbot_stats, name='chatbot_stats'),
    path('api/chatbot/rebuild/', views.rebuild_vector_store, name='rebuild_vector_store'),
    path('api/applications/search/', views.search_applications, name='search_applications'),
    path('api/applications/<str:application_id>/', views.get_application_details, name='get_application_details'),
    path('api/councils/', views.get_councils, name='get_councils'),
    path('api/development-types/', views.get_development_types, name='get_development_types'),
    path('chatbot/', views.chatbot_interface, name='chatbot_interface'),
]

