from django.shortcuts import render
from rest_framework.response import Response
from rest_framework.views import APIView
from rest_framework import status
from admin_panel.models import *
from django.contrib.auth.hashers import make_password, check_password
from rest_framework_simplejwt.tokens import RefreshToken
from admin_panel.authentication import adminauthenticated
import random
from django.conf import settings
from django.template.loader import render_to_string
from django.core import mail
from django.contrib.auth.models import User
from panel_api.models import *

# Create your views here.


class AdminRegister(APIView):
    def post(self, request):
        try:
            email = request.data.get("email")
            password = request.data.get("password")

            if not email or not password:
                return Response({"message": "Email and password are required"}, status=status.HTTP_400_BAD_REQUEST)

            if User.objects.filter(email=email).exists():
                return Response({"message": "User with this email already exists"}, status=status.HTTP_400_BAD_REQUEST)

            user = User.objects.create_user(
                username=email,
                email=email,
                password=password
            )

            super_admin = SuperAdmin.objects.create(
                user=user,
                email=email,
                password=make_password(password)
            )

            refresh = RefreshToken.for_user(user)

            return Response({
                "message": "Admin registered successfully",
                "access": str(refresh.access_token),
                "refresh": str(refresh),
                "user_id": user.id,
                "email": user.email
            }, status=status.HTTP_201_CREATED)

        except Exception as e:
            return Response({"message": f"Registration failed: {str(e)}"}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class LoginAdmin(APIView):
    def post(self, request):
        try:
            email = request.data.get("email")
            password = request.data.get("password")

            if not email or not password:
                return Response({"message": "Email and password are required"}, status=status.HTTP_400_BAD_REQUEST)
            

            if not email:
                return Response({"message":'email is required'},status=status.HTTP_400_BAD_REQUEST)
            if not password:
                return Response({"message":'password is required'},status=status.HTTP_400_BAD_REQUEST)
        
            try:
                user = SuperAdmin.objects.get(email=email)
            except SuperAdmin.DoesNotExist:
                return Response({"message": "Email not exist"}, status=status.HTTP_401_UNAUTHORIZED)

            if not check_password(password, user.password):
                return Response({"message": "Invalid credentials"}, status=status.HTTP_401_UNAUTHORIZED)
            
            refresh = RefreshToken.for_user(user)

            return Response({
                "message": "Login successful",
                "email": user.email,
                "access": str(refresh.access_token),
                "refresh": str(refresh)
            }, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({"message": f"Login failed: {str(e)}"}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)



class AdminProfile(APIView):
    def get(self,request):
        try:
            try:
                uid = adminauthenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)
            user_obj = User.objects.filter(id=uid).first()

            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)

            admin_obj  = SuperAdmin.objects.all().first()
            if not admin_obj:
                return Response({"message":'Your account has been Inactive, Please contact to admin.',"email":admin_obj.email},status=status.HTTP_406_NOT_ACCEPTABLE)
            all_data ={
                "email":admin_obj.email,
                "firstName":admin_obj.firstName,
                "gender":admin_obj.gender,
                "phoneNumber":admin_obj.phoneNumber,
                "image":admin_obj.image
            }
            return Response({'status_code':status.HTTP_200_OK,'status_message':'Fetched Successfully','all_data':all_data})
        except Exception as e:
            return Response({'message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)

    def post(self,request):
        try:
            try:
                uid = adminauthenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)
            user_obj = User.objects.filter(id = uid).first()

            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
            admin_obj = SuperAdmin.objects.filter(user=user_obj).first()
            if not admin_obj:
                return Response({'message': 'Admin not found'}, status=status.HTTP_404_NOT_FOUND)
            firstName = request.data.get("firstName")
            gender = request.data.get("gender")
            phoneNumber =request.data.get("phoneNumber")
            image = request.data.get("image")

            admin_obj.firstName = firstName
            admin_obj.gender = gender
            admin_obj.phoneNumber = phoneNumber
            admin_obj.image = image
            admin_obj.save()
            print("user_obj",admin_obj)

            return Response({'status_code':status.HTTP_200_OK,'status_message':'Profile updated successfully'})
        except Exception as e:
            return Response({'message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class AdminForgetPassword(APIView):
    def post(self, request):
        try:
            email = request.data.get('email', '').strip().lower()

            if not email:
                return Response({"message": "Email is required"}, status=status.HTTP_400_BAD_REQUEST)

            user_obj = User.objects.filter(email=email).first()
            if not user_obj:
                return Response({"message": "This email does not exist or is not an admin account."},
                                status=status.HTTP_404_NOT_FOUND)

            admin_obj = SuperAdmin.objects.filter(user=user_obj).first()
            if not admin_obj:
                return Response({"message": "SuperAdmin profile not found for this user."},
                                status=status.HTTP_404_NOT_FOUND)

            otp = random.randint(1000, 9999)

            admin_obj.forgot_password_otp = otp
            admin_obj.save()

            subject = "Admin Password Reset OTP"
            html_message = render_to_string('forget_password_otp.html', {'otp': otp, 'email': email})
            plain_message = f"Your OTP for resetting password is {otp}"
            from_email = settings.EMAIL_HOST_USER

            mail.send_mail(subject, plain_message, from_email, [email], html_message=html_message)

            return Response({
                "message": "Password reset OTP has been sent to your email.",
                "email": email
            }, status=status.HTTP_200_OK)

        except Exception as e:
            print(e)
            return Response({"message": f"Error: {str(e)}"}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

class AdminVerifyForgetPasswordOTP(APIView):
    def post(self, request):
        try:
            email = request.data.get('email').strip().lower()
            if not email:
                return Response({
                    'status_code': status.HTTP_400_BAD_REQUEST,
                    'status_message': 'Email is required'
                }, status=status.HTTP_400_BAD_REQUEST)

            otp = request.data.get('otp')
            if not otp:
                return Response({
                    'status_code': status.HTTP_400_BAD_REQUEST,
                    'status_message': 'OTP is required'
                }, status=status.HTTP_400_BAD_REQUEST)

            check_email = SuperAdmin.objects.filter(email=email)
            if not check_email.exists():
                return Response({
                    'status_code': status.HTTP_404_NOT_FOUND,
                    'status_message': 'This email does not exist in our database'
                }, status=status.HTTP_404_NOT_FOUND)

            admin_obj = SuperAdmin.objects.filter(email=email, forgot_password_otp=otp).first()

            if admin_obj:
                return Response({
                    'status_code': status.HTTP_200_OK,
                    'status_message': 'Successfully Verified'
                }, status=status.HTTP_200_OK)
            else:
                return Response({
                    'status_code': status.HTTP_400_BAD_REQUEST,
                    'status_message': 'Invalid OTP'
                }, status=status.HTTP_400_BAD_REQUEST)

        except Exception as e:
            return Response({
                'status_code': status.HTTP_500_INTERNAL_SERVER_ERROR,
                'status_message': str(e)
            }, status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class AdminPrivacyPolicy(APIView):
    def get(self, request):
        try:

            try:
                uid = adminauthenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)
            user_obj = User.objects.filter(id = uid).first()

            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
            admin_obj = SuperAdmin.objects.filter(user=user_obj).first()
            if not admin_obj:
                return Response({'message': 'Admin not found'}, status=status.HTTP_404_NOT_FOUND)
            

            policy = PrivacyPolicy.objects.all().first()
            if not policy:
                return Response({"message": "No Privacy Policy found."}, status=status.HTTP_404_NOT_FOUND)
            return Response({
                "title": policy.title,
                "content": policy.content,
                "last_updated": policy.updated_at
            }, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({"message": str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

    def post(self, request):
        try:
            uid = adminauthenticated(request)
            user = User.objects.get(id=uid)

            content = request.data.get("content")
            if not content:
                return Response({"message": "Content is required"}, status=status.HTTP_400_BAD_REQUEST)

            policy = PrivacyPolicy.objects.all().first()
            if policy:
                policy.content = content
                policy.created_by = user
                policy.save()
                message = "Privacy Policy updated successfully."
            else:
                PrivacyPolicy.objects.create(content=content, created_by=user)
                message = "Privacy Policy created successfully."

            return Response({"message": message}, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({"message": str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)



class AdminTermsCondition(APIView):
    def get(self, request):
        try:

            try:
                uid = adminauthenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)
            user_obj = User.objects.filter(id = uid).first()

            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
            admin_obj = SuperAdmin.objects.filter(user=user_obj).first()
            if not admin_obj:
                return Response({'message': 'Admin not found'}, status=status.HTTP_404_NOT_FOUND)
            
            terms = TermsAndConditions.objects.filter().first()
            if not terms:
                return Response({"message": "No Terms and Conditions found."}, status=status.HTTP_404_NOT_FOUND)
            return Response({
                "title": terms.title,
                "content": terms.content,
                "last_updated": terms.updated_at
            }, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({"message": str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

    def post(self, request):
        try:
            uid = adminauthenticated(request)
            user = User.objects.get(id=uid)

            content = request.data.get("content")
            if not content:
                return Response({"message": "Content is required"}, status=status.HTTP_400_BAD_REQUEST)

            terms = TermsAndConditions.objects.filter().first()
            if terms:
                terms.content = content
                terms.created_by = user
                terms.save()
                message = "Terms & Conditions updated successfully."
            else:
                TermsAndConditions.objects.create(content=content, created_by=user)
                message = "Terms & Conditions created successfully."

            return Response({"message": message}, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({"message": str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

class AdminUserList(APIView):
    def get(self, request):
        try:
            uid = adminauthenticated(request)
            admin = SuperAdmin.objects.filter(user_id=uid).first()
            if not admin:
                return Response({"message": "Unauthorized Access"}, status=status.HTTP_403_FORBIDDEN)

            users = EndUser.objects.all()
            all_Data=[]
            for user_obj in users:
                data = {
                "id": user_obj.id,
                "name": user_obj.name,
                "email": user_obj.email,
                "phone_number": user_obj.phone_number,
                "created_at": user_obj.created_at,
                }
                all_Data.append(data)

            return Response({
                "total_users": users.count(),
                "data": all_Data,
            }, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({"message": str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

class AdminUserDetails(APIView):
    def get(self, request):
        try:
            uid = adminauthenticated(request)
            admin = SuperAdmin.objects.filter(user_id=uid).first()
            if not admin:
                return Response({"message": "Unauthorized Access"}, status=status.HTTP_403_FORBIDDEN)
            user_id = request.GET.get('user_id')
            if not user_id:
                return Response({"message": "user_id is required"}, status=status.HTTP_400_BAD_REQUEST)

            user_obj = EndUser.objects.filter(id=user_id).first()
            if not user_obj:
                return Response({"message": "User not found"}, status=status.HTTP_404_NOT_FOUND)

            data = {
                "id": user_obj.id,
                "name": user_obj.name,
                "email": user_obj.email,
                "phone_number": user_obj.phone_number,
                "created_at": user_obj.created_at,
            }

            return Response({"data": data}, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({"message": str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

class AdminChangePassword(APIView):
    def post(self, request):
        try:
            email = request.data.get('email', '').strip().lower()
            new_password = request.data.get('new_password')
            confirm_password = request.data.get('confirm_password')

            if not email:
                return Response({
                    'status_code': status.HTTP_400_BAD_REQUEST,
                    'status_message': 'Email is required'
                }, status=status.HTTP_400_BAD_REQUEST)

            if not new_password or not confirm_password:
                return Response({
                    'status_code': status.HTTP_400_BAD_REQUEST,
                    'status_message': 'Both password fields are required'
                }, status=status.HTTP_400_BAD_REQUEST)

            if new_password != confirm_password:
                return Response({
                    'status_code': status.HTTP_400_BAD_REQUEST,
                    'status_message': 'Passwords do not match'
                }, status=status.HTTP_400_BAD_REQUEST)

            admin_obj = SuperAdmin.objects.filter(email=email).first()
            if not admin_obj:
                return Response({
                    'status_code': status.HTTP_404_NOT_FOUND,
                    'status_message': 'Admin not found'
                }, status=status.HTTP_404_NOT_FOUND)

            admin_obj.password = make_password(new_password)
            admin_obj.forgot_password_otp = None
            admin_obj.save()

            return Response({
                'status_code': status.HTTP_200_OK,
                'status_message': 'Password changed successfully'
            }, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({
                'status_code': status.HTTP_500_INTERNAL_SERVER_ERROR,
                'status_message': str(e)
            }, status=status.HTTP_500_INTERNAL_SERVER_ERROR)
