from django.db import models

# Create your models here.

class EndUser(models.Model):
	name = models.CharField(max_length=244,default='')
	email = models.EmailField(max_length=100,default='',null=True)
	email_verification_otp = models.IntegerField(null=True)
	email_verified = models.BooleanField(default=False)
	phone_number = models.CharField(max_length=20, default='',null=True)
	phone_number_otp = models.CharField(max_length=20, default='',null=True)
	phone_number_verified = models.BooleanField(default=False)
	password = models.CharField(max_length=250,default='',null=True)
	forgot_password_otp = models.IntegerField(null=True)
	image = models.TextField(null=True)
	is_profile_completed = models.BooleanField(default=False)
	status =  models.BooleanField(default=True)
	account_deleted = models.BooleanField(default=False)
	is_password_reset = models.BooleanField(default=False)
	deleted_reason = models.TextField(null=True)
	created_at = models.DateTimeField(auto_now_add=True)
	last_login = models.DateTimeField(null=True)
	updated_at = models.DateTimeField(auto_now=True)
	end_date = models.DateTimeField(null=True) 

	class Meta:
		db_table = 'end_user'