from passlib.hash import django_pbkdf2_sha256 as handler
from django.shortcuts import render
from machine_shop import settings
from panel_api import urls
from panel_api.models import EndUser
from django.shortcuts import render, redirect,HttpResponse
from rest_framework.response import Response
from rest_framework.views import APIView
from rest_framework import status
from django.contrib.auth.hashers import make_password ,check_password
from rest_framework_simplejwt.tokens import RefreshToken
import random
from django.template.loader import render_to_string
from django.core import mail
from rest_framework.authentication import get_authorization_header
from rest_framework_simplejwt.backends import TokenBackend
from .authentication import authenticated


# Create your views here.

class UserRegister(APIView):
    def post(self,request):
        try:
            data = request.data
            name = data.get('name')
            email = data.get('email').strip().replace(" ", "").lower()
            password = data.get('password')
            if not email:
                return Response({"message":'email is required'},status=status.HTTP_400_BAD_REQUEST)
            if not name:
                return Response({"message":'name is required'},status=status.HTTP_400_BAD_REQUEST)
            if not password:
                return Response({"message":'password is required'},status=status.HTTP_400_BAD_REQUEST)

            new_password = make_password(password)
            check_email = EndUser.objects.filter(email=email).first()
            if check_email:
                return Response({"message":"The email is already registered"},status=status.HTTP_409_CONFLICT)
            else:
                user_obj = EndUser.objects.create(name=name,email=email,password=new_password)
            return Response({"message":'You have been successfully registered with us.'})
        except Exception as e:
            return Response({"message":str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR) 
    
 
class LoginUser(APIView):
    def post(self,request):
        email = request.data.get('email')
        password = request.data.get('password')

        if not email:
            return Response({"message":'email is required'},status=status.HTTP_400_BAD_REQUEST)
        if not password:
            return Response({"message":'password is required'},status=status.HTTP_400_BAD_REQUEST)
        
        try:
            user = EndUser.objects.get(email=email)
        except EndUser.DoesNotExist:
            return Response({"message": "User Not credentials"}, status=status.HTTP_401_UNAUTHORIZED)

        if not check_password(password, user.password):
            return Response({"message": "Invalid credentials"}, status=status.HTTP_401_UNAUTHORIZED)
        
        refresh = RefreshToken.for_user(user)

        return Response({
            "message": "Login successful",
            "username":user.name,
            "access": str(refresh.access_token),
            "refresh": str(refresh)
        }, status=status.HTTP_200_OK)


class UserForgetpassword(APIView):
    def post(self,request):
        try:
            data = request.data
            email =data.get('email').strip().lower()
            if not email:
                return Response({"message":'Email is required'})
            user = EndUser.objects.filter(email= email).count()
            if user == 0:
                return Response({"message":'This email does not exist in our database, please enter the valid email address.'},status=status.HTTP_404_NOT_FOUND)
            user_obj = EndUser.objects.filter(email= email).first()
            if user_obj:
                theotp = random.randrange(1000,9999,5)
                user_obj.forgot_password_otp = theotp
                user_obj.save()
                print('--------------',user_obj,"theotp")
                to_email= user_obj.email
                subject = 'Forget Password OTP'
                html_message = render_to_string('forget_password_otp.html',{'otp':theotp})
                plane_message = html_message
                from_email = settings.EMAIL_HOST_USER
                mail.send_mail(subject,plane_message,from_email,[to_email],html_message= html_message)
                return Response({ "message": "Rendered HTML",
                        "html": html_message})
            else:
                return Response({"message":'Email not exists'})
        except Exception as e:
                print(e)
                return Response({"message":str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)

class verifyForgetPasswordOTP(APIView):
    def post(self,request):
        try:
            
            email= request.data.get('email').strip().lower()
            if not email:
                return Response({'status_code':status.HTTP_400_BAD_REQUEST,'status_message':'Email is required'},status=status.HTTP_400_BAD_REQUEST)
            otp = request.data.get('otp')
            if not otp:
                return Response({'status_code':status.HTTP_400_BAD_REQUEST,'status_message':'otp is Required'},status =status.HTTP_400_BAD_REQUEST)
            email_check= EndUser.objects.filter(email = email).exists()
            if not email_check:
                return Response ({'status_code':status.HTTP_400_BAD_REQUEST,'status_message':'Email not exist'},status=status.HTTP_400_BAD_REQUEST)
            
            user_obj = EndUser.objects.filter(email = email,forgot_password_otp = otp).first()
            if user_obj:
                return Response({'status_code':status.HTTP_200_OK,'status_message':'Successfully Verified'})
            else:
                return Response({'status_code':status.HTTP_400_BAD_REQUEST,'status_message':'Invalid otp'})
            
        except Exception as e:
                return Response({'status_code':status.HTTP_500_INTERNAL_SERVER_ERROR,'status_message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)
        

class changeForgetPassword(APIView):
	def post(self,request):
		try:
			email = request.data.get('email').strip().lower()
			if not email:
				return Response({'message': 'email is required'}, status=status.HTTP_404_NOT_FOUND)
			user_obj = EndUser.objects.filter(email=email).first()
			if not user_obj:
				return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
			new_password = request.data.get('new_password')
			if not new_password:
				return Response({'message':'new password is required'},status=status.HTTP_400_BAD_REQUEST)
			confirm_password = request.data.get('confirm_password')
			if not confirm_password:
				return Response({'message':'confirm password is required'},status=status.HTTP_400_BAD_REQUEST)
			if new_password != confirm_password:
				return Response({'message':'Password and confirm password are not same.'},status=status.HTTP_403_FORBIDDEN)
			encrypt_password = handler.hash(confirm_password)
			user_obj.password = encrypt_password
			user_obj.save()
			return Response({'message':'Success'}) 
		except Exception as e:
			return Response({'message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)
          


		

class UserProfile(APIView):
    def get(self, request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e:
                return Response({'message':str(e)},status=status.HTTP_401_UNAUTHORIZED)
            user_obj = EndUser.objects.filter(id=uid).first()
            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
            user = EndUser.objects.get(email=user_obj.email)
            data = {
                "name": user.name,
                "email": user.email,
                "phone_number": user.phone_number,
                "image": request.build_absolute_uri(user.image.url) if user.image else None,
                "is_profile_completed": user.is_profile_completed,
                "created_at": user.created_at,
                "updated_at": user.updated_at
            }
            return Response({
                "message": "Profile fetched successfully",
                'data':data,
            }, status=status.HTTP_200_OK)
        except EndUser.DoesNotExist:
            return Response({"message": "User not found"}, status=status.HTTP_404_NOT_FOUND)

    def post(self, request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e:
                return Response({'message':str(e)},status=status.HTTP_401_UNAUTHORIZED)
            user_obj = EndUser.objects.filter(id=uid).first()
            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
                
            user = EndUser.objects.get(email=user_obj.email)


            name = request.data.get('name')
            if not name:
                return Response({'message': 'name is required'}, status=status.HTTP_400_BAD_REQUEST)
            
            phone = request.data.get('phone')
            if not phone:
                return Response({'message': 'phone is required'}, status=status.HTTP_400_BAD_REQUEST)
            
            image = request.data.get('image')
            if not image:
                return Response({'message': 'image is required'}, status=status.HTTP_400_BAD_REQUEST)
            
            user.name = name
            user.phone_number = phone
            user.image = image
            user.is_profile_completed = True
            user.save()

            data = {
                "name": user.name,
                "email": user.email,
                "phone_number": user.phone_number,
                "image": request.build_absolute_uri(user.image.url) if user.image else None,
                "is_profile_completed": user.is_profile_completed,
                "created_at": user.created_at,
                "updated_at": user.updated_at
            }
            return Response({
                "message": "Profile updated successfully",
                'data':data,
            }, status=status.HTTP_200_OK)
        

        except EndUser.DoesNotExist:
            return Response({"message": "User not found"}, status=status.HTTP_404_NOT_FOUND)
        

    
class ResetPassword(APIView):
	def post(self,request):
		try:
			try:
				uid = authenticated(request)
			except Exception as e:
				return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)
			user_obj = EndUser.objects.filter(id=uid).first()
			if not user_obj:
				return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)

			old_password = request.data.get('old_password')
			if not old_password:
				return Response({'message':'old password is required'},status=status.HTTP_400_BAD_REQUEST)
               
			new_password = request.data.get('new_password')
			if not new_password:
				return Response({'message':'new password is required'},status=status.HTTP_400_BAD_REQUEST)
               
			check_password = user_obj.password
			check = handler.verify(old_password,check_password)
			if check == False:
				return Response({'message':'Old password is incorrect'},status=status.HTTP_403_FORBIDDEN)
			password = new_password
			encrypt_password = handler.hash(password)
			user_obj.password = encrypt_password
			user_obj.save()
			return Response({'message':'Success'}) 
		except Exception as e:
			return Response({'message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)