# Troy Email Fetcher API

REST API for fetching and retrieving email booking details from Twine scheduling emails.

## Installation

1. Install dependencies:
```bash
pip install -r requirements.txt
```

2. Set environment variables:
```bash
export CLIENT_SECRET='your-client-secret-value'
export EMAIL_ADDRESS='info@troyrides.com'  # Optional, has default
export CLIENT_ID='your-client-id'  # Optional, has default
export TENANT_ID='your-tenant-id'  # Optional, has default
```

## Running the API

### Basic Usage

```bash
python api.py
```

The API will start on `http://0.0.0.0:5000` by default.

### Custom Port and Host

```bash
export PORT=8080
export HOST=127.0.0.1
python api.py
```

## API Endpoints

### 1. Health Check

**GET** `/health`

Check if the API is running.

**Response:**
```json
{
  "status": "healthy",
  "service": "Troy Email Fetcher API"
}
```

### 2. Fetch Emails

**GET** `/api/emails`

Fetch emails with extracted booking details.

**Query Parameters:**
- `sender` (optional): Email address to filter by (default: `scheduling@usetwine.com`)
- `folder` (optional): Email folder to search (default: `inbox`)
- `unread_only` (optional): Only fetch unread emails (default: `false`)
- `from_date` (optional): Fetch emails from this date onwards (format: `YYYY-MM-DD`)
- `limit` (optional): Maximum number of emails to return (default: `100`)

**Example Request:**
```bash
curl "http://localhost:5000/api/emails?sender=scheduling@usetwine.com&from_date=2025-12-17&limit=10"
```

**Response:**
```json
{
  "success": true,
  "count": 5,
  "emails": [
    {
      "id": "AAMkADA5YzVkNjM2...",
      "subject": "Troy Rides: Twine Customer 103682",
      "from": "Twine Updates <scheduling@usetwine.com>",
      "date": "2025-12-17T03:33:32Z",
      "body": "New Ride Call Back: Call Back for Tay Tay...",
      "extracted_details": {
        "name": "Tay Tay",
        "phone": "(323) 359-6264",
        "email": "t-zaidan@live.com",
        "address": "4018 Buckingham Road, Los Angeles, CA, 90008",
        "date_time": "2025-11-20 4:10 AM",
        "date": "2025-11-20",
        "time": "4:10 AM",
        "pick_up_location": "4018 Buckingham Rd Los Angeles CA 90008",
        "drop_off_location": "300 S Main St Los Angeles CA 90013",
        "number_of_passengers": "1"
      }
    }
  ]
}
```

### 3. Fetch Emails Summary

**GET** `/api/emails/summary`

Fetch emails but return only summary (without full email body).

**Query Parameters:** Same as `/api/emails`

**Example Request:**
```bash
curl "http://localhost:5000/api/emails/summary?from_date=2025-12-17"
```

**Response:**
```json
{
  "success": true,
  "count": 5,
  "emails": [
    {
      "id": "AAMkADA5YzVkNjM2...",
      "subject": "Troy Rides: Twine Customer 103682",
      "from": "Twine Updates <scheduling@usetwine.com>",
      "date": "2025-12-17T03:33:32Z",
      "extracted_details": {
        "name": "Tay Tay",
        "phone": "(323) 359-6264",
        "email": "t-zaidan@live.com",
        "address": "4018 Buckingham Road, Los Angeles, CA, 90008",
        "date_time": "2025-11-20 4:10 AM",
        "date": "2025-11-20",
        "time": "4:10 AM",
        "pick_up_location": "4018 Buckingham Rd Los Angeles CA 90008",
        "drop_off_location": "300 S Main St Los Angeles CA 90013",
        "number_of_passengers": "1"
      }
    }
  ]
}
```

### 4. Get Email by ID

**GET** `/api/emails/<email_id>`

Get a specific email by its ID.

**Example Request:**
```bash
curl "http://localhost:5000/api/emails/AAMkADA5YzVkNjM2..."
```

**Response:**
```json
{
  "success": true,
  "email": {
    "id": "AAMkADA5YzVkNjM2...",
    "subject": "Troy Rides: Twine Customer 103682",
    "from": "Twine Updates <scheduling@usetwine.com>",
    "date": "2025-12-17T03:33:32Z",
    "body": "Full email body...",
    "extracted_details": {
      ...
    }
  }
}
```

## Error Responses

All endpoints return error responses in this format:

```json
{
  "success": false,
  "error": "Error message here"
}
```

**HTTP Status Codes:**
- `200`: Success
- `400`: Bad Request (configuration error, invalid parameters)
- `404`: Not Found (email ID not found, endpoint not found)
- `500`: Internal Server Error

## Examples

### Fetch recent emails from a specific date

```bash
curl "http://localhost:5000/api/emails?from_date=2025-12-17&limit=20"
```

### Fetch only unread emails

```bash
curl "http://localhost:5000/api/emails?unread_only=true"
```

### Fetch emails from a different sender

```bash
curl "http://localhost:5000/api/emails?sender=another@example.com"
```

### Fetch emails summary (lighter response)

```bash
curl "http://localhost:5000/api/emails/summary?from_date=2025-12-17"
```

## Production Deployment

### Using Gunicorn

```bash
pip install gunicorn
gunicorn -w 4 -b 0.0.0.0:5000 api:app
```

### Using systemd Service

Create `/etc/systemd/system/troy-email-api.service`:

```ini
[Unit]
Description=Troy Email Fetcher API
After=network.target

[Service]
Type=simple
User=www-data
WorkingDirectory=/var/www/html/troy
Environment="CLIENT_SECRET=your-secret-value"
Environment="PORT=5000"
ExecStart=/var/www/html/troy/venv/bin/python api.py
Restart=always

[Install]
WantedBy=multi-user.target
```

Then:
```bash
sudo systemctl enable troy-email-api
sudo systemctl start troy-email-api
```

### Using Docker

Create `Dockerfile`:

```dockerfile
FROM python:3.10-slim

WORKDIR /app

COPY requirements.txt .
RUN pip install --no-cache-dir -r requirements.txt

COPY . .

EXPOSE 5000

CMD ["python", "api.py"]
```

Build and run:
```bash
docker build -t troy-email-api .
docker run -d -p 5000:5000 \
  -e CLIENT_SECRET='your-secret' \
  -e EMAIL_ADDRESS='info@troyrides.com' \
  troy-email-api
```

## Security Notes

1. **Never commit CLIENT_SECRET to version control**
2. Use environment variables for sensitive data
3. Consider adding authentication/authorization for production
4. Use HTTPS in production
5. Rate limit API endpoints to prevent abuse

## Logging

API logs are written to `logs/api.log` and include:
- Request details
- Response status
- Errors and exceptions
- Authentication status

