# Quick Setup Guide for Microsoft Graph API

## Step 1: Install Dependencies

```bash
pip install -r requirements.txt
```

Or if using the virtual environment:

```bash
source venv/bin/activate  # On Windows: venv\Scripts\activate
pip install -r requirements.txt
```

## Step 2: Get Your Azure AD Credentials

You need three pieces of information from Azure Portal:

1. **Client ID** (Application ID)
2. **Client Secret**
3. **Tenant ID** (Directory ID)

### How to Get These:

1. Go to https://portal.azure.com
2. Navigate to **Azure Active Directory** > **App registrations**
3. Find your app (or create a new one)
4. **Client ID**: Found on the **Overview** page (Application (client) ID)
5. **Tenant ID**: Found on the **Overview** page (Directory (tenant) ID)
6. **Client Secret**: 
   - Go to **Certificates & secrets**
   - Create a new client secret if you don't have one
   - Copy the **Value** (not the Secret ID) - you can only see it once!

## Step 3: Configure API Permissions

1. In your app registration, go to **API permissions**
2. Click **Add a permission** > **Microsoft Graph** > **Application permissions**
3. Add: `Mail.Read`
4. Click **Grant admin consent for [Your Organization]**

## Step 4: Update fetch.py

Open `fetch.py` and update these lines in the `main()` function (around line 430):

```python
EMAIL_ADDRESS = "info@troyrides.com"
CLIENT_ID = "paste-your-client-id-here"
CLIENT_SECRET = "paste-your-client-secret-here"
TENANT_ID = "paste-your-tenant-id-here"
```

## Step 5: Run the Script

```bash
python fetch.py
```

## Troubleshooting

### "Failed to obtain access token"
- Double-check your Client ID, Client Secret, and Tenant ID
- Make sure admin consent was granted for the API permissions
- Verify the client secret hasn't expired

### "Insufficient privileges"
- Go back to Azure Portal and click **Grant admin consent** in API permissions
- Make sure you added `Mail.Read` as an **Application permission** (not Delegated)

### "No module named 'msal'"
- Run: `pip install -r requirements.txt`

