from bs4 import BeautifulSoup
from securityheaders.core import analyze_url
import requests
from wp_version_checker import check_domains
import re
import time
import json
import datetime
import os
from concurrent.futures import ThreadPoolExecutor
from django.conf import settings

GT_METRIX_API_KEY = "87462e4c14a52f0fe604d410bcee4f1a"


class PDFGenerator:
	path = "./media/"

	def directory_exists(self):
		if not os.path.exists(self.path):
			os.makedirs(self.path)

	def download(self, url, save_path):
		if not url:
			return ""

		auth = (GT_METRIX_API_KEY, "")
		self.directory_exists()

		print(f"{'Updating' if os.path.exists(save_path) else 'Creating new'} PDF: {save_path}")

		with requests.Session() as session:
			response = session.get(url, auth=auth)

		if response.status_code == 200:
			with open(save_path, 'wb') as pdf_file:
				pdf_file.write(response.content)
			return f"{save_path[1:]}"
		else:
			print("Failed to update/create PDF. Error:", response.status_code)
			return ''


def run_gtmetrix_script():
   pdf_generator = PDFGenerator()

   def get_leads_website():
       main_db = "https://xsnk-cltn-rqv5.n7c.xano.io/api:LbJeqyay/maindb"
       headers = {"accept": "application/json"}
       response = requests.get(main_db, headers=headers)
       data = response.json()
       website_data = [(entry.get('site_web'), entry.get('id')) for entry in data]
       print("website_data", website_data)
       return website_data

   def get_gtmetrix_data(url):
       endpoint = "https://gtmetrix.com/api/2.0/tests"
       headers = {"Content-Type": "application/vnd.api+json"}
       auth = (GT_METRIX_API_KEY, '')

       data = {"data": {"type": "test", "attributes": {"url": url, "adblock": 1}}}

       with requests.Session() as session:
           response = session.post(endpoint, headers=headers, auth=auth, json=data)

       print("get leads response", response)
       if response.status_code == 429:
           print(f"Too many tests pending for {url}. Waiting for the first response...")
           while response.status_code == 429:
               time.sleep(10)  # Wait for 10 seconds
               with requests.Session() as session:
                   response = session.post(endpoint, headers=headers, auth=auth, json=data)

       gtmetrix_data = response.json()

       print("gtmetrix_data", gtmetrix_data)

       time.sleep(20)
       return gtmetrix_data

   def get_gtmetrix_data_parallel(website_data):
       with ThreadPoolExecutor() as executor:
           gtmetrix_data_list = list(executor.map(get_gtmetrix_data, [url for url, _ in website_data]))

       return gtmetrix_data_list

   website_data = get_leads_website()
   gtmetrix_data_list = get_gtmetrix_data_parallel(website_data)

   # Perform GTmetrix test for each website URL
   for (website_url, maindb_id), gtmetrix_data in zip(website_data, gtmetrix_data_list):
       test_id = gtmetrix_data.get('data', {}).get('id')
       api_url = f"https://gtmetrix.com/api/2.0/tests/{test_id}"
       with requests.Session() as session:
           response = session.get(api_url, auth=(GT_METRIX_API_KEY, ''))

       if response.status_code == 200:
           data = response.json()
           if 'state' in data['data']['attributes'] and data['data']['attributes']['state'] == 'error':
               print(f"Test with ID {test_id} is in an error state. Skipping further processing.")
           else:
               # Polling loop to wait for the test to complete
               while 'report_url' not in data['data']['links']:
                   time.sleep(5)  # Adjust the sleep interval as needed
                   with requests.Session() as session:
                       response = session.get(api_url, auth=(GT_METRIX_API_KEY, ''))
                       data = response.json()

               url = 'https://xsnk-cltn-rqv5.n7c.xano.io/api:LbJeqyay/gtmetrix'

               headers = {
                   'accept': 'application/json',
                   'Content-Type': 'application/json'
               }

               maindb_id = maindb_id
               print('maindb_id', maindb_id)
               updated_at = datetime.datetime.now().isoformat()
               print('updated_at', updated_at)

               gtmetrix_data = data['data']['attributes']['gtmetrix_grade']
               print('gtmetrix_data', gtmetrix_data)

               performance_score = data['data']['attributes']['performance_score']
               print('performance_score', performance_score)

               structure_score = data['data']['attributes']['structure_score']
               print('structure_score', structure_score)

               largest_contentful_paint = data['data']['attributes']['largest_contentful_paint']
               print('largest_contentful_paint', largest_contentful_paint)

               total_blocking_time = data['data']['attributes']['total_blocking_time']
               print('total_blocking_time', total_blocking_time)

               cumulative_layout_shift = data['data']['attributes']['cumulative_layout_shift']
               print('cumulative_layout_shift', cumulative_layout_shift)

               link = data['data']['links']['test']
               print('link', link)

               gtmetrix_pdf = data['data']['links']['report_pdf']
               print('gtmetrix_pdf', gtmetrix_pdf)

               pdf_filename = f"gtmetrix_report_{maindb_id}.pdf"
               pdf_filepath = os.path.join(pdf_generator.path, pdf_filename)

               # Download the PDF file and get the server PDF path
               server_pdf_path = pdf_generator.download(gtmetrix_pdf, pdf_filepath)
               print('server_pdf_path', server_pdf_path)

               payload = {
                   "maindb_id": int(maindb_id),
                   "updated_at": updated_at,
                   "gtmetrix_grade": str(gtmetrix_data),
                   "performance_score": int(performance_score),
                   "structure_score": int(structure_score),
                   "largest_contentful_paint": int(largest_contentful_paint),
                   "total_blocking_time": int(total_blocking_time),
                   "cumulative_layout_shift": float(cumulative_layout_shift),
                   "link": str(link),
                   "is_complete": False,
                   "gtmetrix_pdf": str(gtmetrix_pdf),
                   "server_pdf": str(settings.BASE_URL) + str(server_pdf_path),
                   "website_url": str(website_url)
               }

               with requests.Session() as session:
                   response = session.post(url, headers=headers, data=json.dumps(payload))
               print("final_response", response)

               if response.status_code == 200:
                   print("Data sent successfully!")
               else:
                   print(f"Failed to send data. Status code: {response.status_code}")
       else:
           print("Failed to fetch GTmetrix test data. Status code:", response.status_code)
